#!/bin/bash

cd ~/Desktop/Prac04-Embedded-ARM-With-QEMU

arm-none-eabi-gcc -c -mcpu=arm926ej-s test.c -o test.o

arm-none-eabi-as -mcpu=arm926ej-s -g startup.s -o startup.o

arm-none-eabi-ld -T test.ld test.o startup.o -o test.elf

arm-none-eabi-objcopy -O binary test.elf test.bin

mkimage -A arm -C none -O linux -T kernel -d test.bin -a 0x00100000 -e 0x00100000 test.uimg

cat u-boot-2010.03/u-boot.bin test.uimg >flash.bin

